/*******************************************************
Filename		:  	DW_medium_select.sql
Release 		:  	STORET c2.0B
SIR			:  	1504
Description		:  	Creates a web page section that allows the user to select Activity Medium
				to query Results. 
Author		:  	Christine Tsang
Date			: 	August 7, 2003
Comments		:  	Called by other procedures.
**********************************************************/
SET DEF OFF;

CREATE OR REPLACE PROCEDURE DW_medium_select(tabstart in number) AS

--used to generate Activity Medium list 
CURSOR cmed IS
SELECT pk_isn, activity_medium medium
FROM di_activity_medium
WHERE activity_medium <> 'Biological'
ORDER BY pk_isn;

BEGIN
-- Activity Medium selection
htp.print ('
<h4>Activity Medium</h4>
<table BORDER WIDTH="100%">
<tr>
<td align="center" width="50%">
Select one or more Activity Medium
<BR>
<INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="        ACTIVITY MEDIUM" size="33">
<FONT face="Courier"><BR>
<SELECT NAME="D_MEDIUM_LIST" SIZE="7" tabindex='|| to_char(tabstart)||' MULTIPLE style="font: 10pt/12pt COURIER" >
<OPTION SELECTED  value="ALL">Select All____________________');

    for cmed_var in cmed  LOOP
      htp.formSelectOption(cmed_var.medium||'~', cattributes => 'value= '||cmed_var.PK_ISN);
    END LOOP;

htp.print('</SELECT>
<BR>
</TD>
</TR>
</TABLE>');

END;
/
SHOW ERRORS;
